#include <bits/stdc++.h>
using namespace std;

struct Mast {
    long long x, h;
};

long long chebyshev(long long x1, long long y1, long long x2, long long y2) {
    return max(abs(x1 - x2), abs(y1 - y2));
}

// ????????? ?? ?????
struct Rope {
    long long x1, h1, x2, h2;
    long long t, ymax; // ??? ? ?????????? ??????
    
    // ??????????????? ??????
    void init(long long _x1, long long _h1, long long _x2, long long _h2) {
        x1 = _x1; h1 = _h1; x2 = _x2; h2 = _h2;
        t = (h1 + x1 - h2 + x2) / 2;
        ymax = h1 + x1 - t;
    }
    
    // ?? ?? ????? ??????? ?????? h?
    bool reaches(long long h) const {
        return ymax >= h;
    }
    
    // ????????? ?? ????? (x0, h0) ?? ???????? ????? ?? ?????? ?? ??????? = h0
    long long distance(long long x0, long long h0) const {
        if (!reaches(h0)) return LLONG_MAX;
        
        // ???????? ??? ?? ?????? ?????? = h0: [t - (ymax - h0), t + (ymax - h0)]
        long long L = t - (ymax - h0);
        long long R = t + (ymax - h0);
        
        // ?????????? ?? ????? ?????? [x1, x2]
        L = max(L, x1);
        R = min(R, x2);
        
        if (L > R) return LLONG_MAX;
        
        // ???????? ?????
        long long x_nearest = max(L, min(R, x0));
        long long y_nearest = ymax - abs(x_nearest - t);
        
        // ??? ?? ????? ???? ??????, ???????? ???????
        if (x_nearest == x0 && y_nearest == h0) {
            if (L < x0) {
                long long yL = ymax - abs(L - t);
                return chebyshev(x0, h0, L, yL);
            }
            if (R > x0) {
                long long yR = ymax - abs(R - t);
                return chebyshev(x0, h0, R, yR);
            }
            return LLONG_MAX;
        }
        
        return chebyshev(x0, h0, x_nearest, y_nearest);
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n;
    if (!(cin >> n)) return 0;
    
    vector<Mast> masts(n);
    for (int i = 0; i < n; i++) cin >> masts[i].x;
    for (int i = 0; i < n; i++) cin >> masts[i].h;
    
    // ????????? ?? x-??????????
    vector<int> order(n);
    iota(order.begin(), order.end(), 0);
    sort(order.begin(), order.end(), [&](int a, int b) {
        return masts[a].x < masts[b].x;
    });
    
    // ??????? ????????
    vector<Rope> ropes;
    for (int i = 0; i < n-1; i++) {
        Rope rope;
        int idx1 = order[i], idx2 = order[i+1];
        rope.init(masts[idx1].x, masts[idx1].h, masts[idx2].x, masts[idx2].h);
        ropes.push_back(rope);
    }
    
    vector<long long> answer(n, LLONG_MAX);
    
    // ?? ????? ?????? ???????? ???????? ?????
    for (int i = 0; i < n; i++) {
        long long best = LLONG_MAX;
        long long xi = masts[i].x, hi = masts[i].h;
        
        // ??????? ?????? ???????
        for (int j = 0; j < n; j++) {
            if (i == j) continue;
            if (masts[j].h < hi) continue;
            long long d = chebyshev(xi, hi, masts[j].x, masts[j].h);
            best = min(best, d);
        }
        
        // ??????? ????????
        for (const Rope& rope : ropes) {
            long long d = rope.distance(xi, hi);
            if (d != LLONG_MAX && d == 0) continue; // ??????????? ????????? ??????
            best = min(best, d);
        }
        
        answer[i] = (best == LLONG_MAX) ? -1 : best;
    }
    
    for (int i = 0; i < n; i++) {
        cout << answer[i] << "\n";
    }
    
    return 0;
}